// Mobile Menu Toggle
document.addEventListener('DOMContentLoaded', function() {
    const mobileMenuBtn = document.querySelector('.mobile-menu-btn');
    const navLinks = document.querySelector('.nav-links');
    const navActions = document.querySelector('.nav-actions');

    if (mobileMenuBtn) {
        mobileMenuBtn.addEventListener('click', function() {
            this.classList.toggle('active');

            // Create mobile menu if it doesn't exist
            let mobileMenu = document.querySelector('.mobile-menu');

            if (!mobileMenu) {
                mobileMenu = document.createElement('div');
                mobileMenu.className = 'mobile-menu';
                mobileMenu.innerHTML = `
                    <div class="mobile-menu-content">
                        <ul class="mobile-nav-links">
                            <li><a href="#products">Products</a></li>
                            <li><a href="#why-us">Why Us</a></li>
                            <li><a href="#how-it-works">How It Works</a></li>
                            <li><a href="#solutions">Solutions</a></li>
                            <li><a href="#pricing">Pricing</a></li>
                        </ul>
                        <div class="mobile-nav-actions">
                            <a href="#" class="btn btn-secondary btn-block">Sign In</a>
                            <a href="#" class="btn btn-primary btn-block">Get Started</a>
                        </div>
                    </div>
                `;
                document.body.appendChild(mobileMenu);

                // Add mobile menu styles
                const style = document.createElement('style');
                style.textContent = `
                    .mobile-menu {
                        position: fixed;
                        top: var(--header-height);
                        left: 0;
                        right: 0;
                        bottom: 0;
                        background-color: var(--color-bg);
                        z-index: 999;
                        opacity: 0;
                        visibility: hidden;
                        transition: all 0.3s ease;
                    }
                    .mobile-menu.active {
                        opacity: 1;
                        visibility: visible;
                    }
                    .mobile-menu-content {
                        padding: 24px;
                    }
                    .mobile-nav-links {
                        margin-bottom: 32px;
                    }
                    .mobile-nav-links li {
                        margin-bottom: 8px;
                    }
                    .mobile-nav-links a {
                        display: block;
                        padding: 12px 0;
                        font-size: 1.125rem;
                        color: var(--color-text-muted);
                        border-bottom: 1px solid var(--color-border);
                        transition: color 0.15s ease;
                    }
                    .mobile-nav-links a:hover {
                        color: var(--color-text);
                    }
                    .mobile-nav-actions {
                        display: flex;
                        flex-direction: column;
                        gap: 12px;
                    }
                    .mobile-menu-btn.active span:nth-child(1) {
                        transform: rotate(45deg) translate(5px, 5px);
                    }
                    .mobile-menu-btn.active span:nth-child(2) {
                        opacity: 0;
                    }
                    .mobile-menu-btn.active span:nth-child(3) {
                        transform: rotate(-45deg) translate(5px, -5px);
                    }
                `;
                document.head.appendChild(style);

                // Close menu when clicking a link
                mobileMenu.querySelectorAll('a').forEach(link => {
                    link.addEventListener('click', () => {
                        mobileMenu.classList.remove('active');
                        mobileMenuBtn.classList.remove('active');
                    });
                });
            }

            mobileMenu.classList.toggle('active');
        });
    }

    // Smooth scroll for anchor links
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function(e) {
            const href = this.getAttribute('href');
            if (href === '#') return;

            e.preventDefault();
            const target = document.querySelector(href);
            if (target) {
                const headerHeight = document.querySelector('.header').offsetHeight;
                const targetPosition = target.getBoundingClientRect().top + window.pageYOffset - headerHeight - 20;

                window.scrollTo({
                    top: targetPosition,
                    behavior: 'smooth'
                });
            }
        });
    });

    // Header background on scroll
    const header = document.querySelector('.header');
    if (header) {
        window.addEventListener('scroll', function() {
            if (window.scrollY > 100) {
                header.style.backgroundColor = 'rgba(14, 18, 23, 0.98)';
            } else {
                header.style.backgroundColor = 'rgba(14, 18, 23, 0.95)';
            }
        });
    }

    // Animate elements on scroll
    const observerOptions = {
        threshold: 0.1,
        rootMargin: '0px 0px -50px 0px'
    };

    const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.classList.add('animate-in');
            }
        });
    }, observerOptions);

    // Observe cards and sections
    document.querySelectorAll('.product-card, .feature-card, .industry-card, .pricing-card, .step-item').forEach(el => {
        el.style.opacity = '0';
        el.style.transform = 'translateY(20px)';
        el.style.transition = 'opacity 0.5s ease, transform 0.5s ease';
        observer.observe(el);
    });

    // Add animation class styles
    const animationStyle = document.createElement('style');
    animationStyle.textContent = `
        .animate-in {
            opacity: 1 !important;
            transform: translateY(0) !important;
        }
    `;
    document.head.appendChild(animationStyle);
});
